#!/bin/ksh
[ "${LOGNAME:-$USER}" = root ] ||
decho=echo

print_usage(){
  cat <<EOF
usage:
	sudo $(basename $0) [-h|--help] [--dry-run]

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
while [ $# -gt 0 ]; do
  case "$1" in
  -h|--help)	print_usage; exit 0;;
  --dry-run)	decho=echo;;
  esac
  shift
done

kept_file(){	# $0 /etc/sshd_config
  keep_file="$1"
  kept_file=
  if [ -f "$keep_file" ]; then
    kept_file="${keep_file}~"
    while [ -f "$kept_file" ]; do kept_file="${kept_file}~"; done
    echo "$kept_file"
    return 0
  else
    echo "$keep_file"
    return 1
  fi
}
modify_sshd_config(){	# $0 /etc/sshd_config~
  sed -e '
/^PermitRootLogin .*$/d
/^#PermitRootLogin yes$/{
  a \
PermitRootLogin no
}
/^PasswordAuthentication .*$/d
/^#PasswordAuthentication yes$/{
  a \
PasswordAuthentication no
}
/^ChallengeResponseAuthentication .*$/d
/^#ChallengeResponseAuthentication yes$/{
  a \
ChallengeResponseAuthentication no
}
/^UsePAM .*$/d
/^#UsePAM no$/{
  a \
UsePAM yes
}
/^X11Forwarding .*$/d
/^#X11Forwarding no$/{
  a \
X11Forwarding yes
}
/^X11UseLocalhost .*$/d
/^#X11UseLocalhost yes$/{
  a \
X11UseLocalhost no
}
' "$1"
}
modify_man_conf(){	# $0 /etc/man.conf~
  sed -e '
/^MANPATH	\/Applications\/Xcode\.app\/Contents\/Developer\/usr\/share\/man$/d
/^MANPATH	\/Applications\/Server\.app\/Contents\/ServerRoot\/usr\/share\/man$/d
/^MANPATH	\/usr\/share\/man$/{
  i \
MANPATH	/Applications/Xcode.app/Contents/Developer/usr/share/man\
MANPATH	/Applications/Server.app/Contents/ServerRoot/usr/share/man
}
' "$1"
}
{
  keep_file=/etc/sshd_config
  diff -u "$keep_file" <(modify_sshd_config "$keep_file") > /dev/null || {
    kept_file=$(kept_file "$keep_file") &&
    $decho mv "$keep_file" "$kept_file" &&
    $decho eval modify_sshd_config "$kept_file" '>' "$keep_file"
  }
}
{
  keep_file=/etc/man.conf
  diff -u "$keep_file" <(modify_man_conf "$keep_file") > /dev/null || {
    kept_file=$(kept_file "$keep_file") &&
    $decho mv "$keep_file" "$kept_file" &&
    $decho eval modify_man_conf "$kept_file" '>' "$keep_file"
  }
}
