#!/bin/ksh
[ "${LOGNAME:-$USER}" = root ] ||
decho=echo
localnet_dscl_flags='-u diradmin -p'
localnet_dscl_domain='/LDAPv3/127.0.0.1'
getgrvalue(){
  dscl="dscl $localnet_dscl_domain"
  #dscl="dscl ."
  $dscl -read /Groups/"$1" "$2" | sed -ne "1{;s/^$2:[	 ]*\\(.*\\)\$/\\1/p;q;}"
}
print_usage(){
  me=$(basename "$0")
  cat <<EOF
$me - delete a group
usage:
	$me [-h|--help] [--dry-run] [--dscl '$localnet_dscl_flags'] [--domain $localnet_dscl_domain] [options] group
	sudo $me [-r] group

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
clear_properties(){
  home_dir=
  rm_home_dir=false
  group=
}
reset_properties(){
  [ $# -gt 0 ] || { print_usage; exit 1; }
  eval group="\${$#}"
  dscl="dscl $localnet_dscl_domain"
  #dscl="dscl ."
  $dscl -readall /Groups | grep -q -e "^RecordName: $group\$" || return 1
  home_dir="/Groups/$group"
  while [ $# -gt 0 ]; do
    case "$1" in
    -h|--help)	print_usage; exit 0;;
    --dry-run)	decho=echo;;
    --dscl)	[ $# -gt 1 ] && shift && localnet_dscl_flags="$1";;
    --domain)	[ $# -gt 1 ] && shift && localnet_dscl_domain="$1";;
    -r)	rm_home_dir=:;;
    esac
    shift
  done
  group_id=$(getgrvalue "$group" PrimaryGroupID)
}
print_properties(){
  cat <<EOF
home_dir:	$home_dir
rm_home_dir:	$rm_home_dir
group:		$group
group_id:	$group_id
EOF
  echo
}
dothe_properties(){
  dscl="dscl $localnet_dscl_flags $localnet_dscl_domain"
  #dscl="dscl ."
  $decho $dscl -delete /Groups/"$group" &&
  $rm_home_dir || return 0
  [ -d "$home_dir" ] || return 0
  $decho mv "$home_dir" "$home_dir".deleted-$(date '+%Y%m%d%H%M%S')
}
clear_properties	&&
reset_properties "$@"	&&
print_properties	&&
dothe_properties
