#!/bin/ksh
[ "${LOGNAME:-$USER}" = root ] ||
decho=echo
last_gid(){
  dscl . -readall /Groups |
  sed -ne 's/^PrimaryGroupID: \([0-9][0-9]*\)/\1/p' |
  sort -n | tail -n 1
}
print_usage(){
  me=$(basename "$0")
  cat <<EOF
$me - create a new group
usage:
	$me [-h|--help] [--dry-run] [options] group
	sudo $me [-c full_name] [-d home_dir] [-g group] [-m] group

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
clear_properties(){
  home_dir=
  group_id=$(($(last_gid)+1))
  mk_home_dir=false
  group=
}
reset_properties(){
  [ $# -gt 0 ] || { print_usage; exit 1; }
  eval group="\${$#}"
  #dscl="dscl $localnet_dscl_domain"
  dscl="dscl ."
  $dscl -readall /Groups | grep -q -e "^RecordName: $group\$" && return 1
  home_dir="/Groups/$group"
  while [ $# -gt 0 ]; do
    case "$1" in
    -h|--help)	print_usage; exit 0;;
    --dry-run)	decho=echo;;
    -c)	[ $# -gt 1 ] && shift && comment="$1";;
    -d)	[ $# -gt 1 ] && shift && home_dir="$1";;
    -g)	[ $# -gt 1 ] && shift && group_id="$1";;
    -m)	mk_home_dir=:;;
    esac
    shift
  done
  [ "$comment" != "" ] || comment="$group"
}
print_properties(){
  cat <<EOF
comment:	$comment
home_dir:	$home_dir
group_id:	$group_id
mk_home_dir:	$mk_home_dir
group:		$group
EOF
  echo
}
dothe_properties(){
  #dscl="dscl $localnet_dscl_flags $localnet_dscl_domain"
  dscl="dscl ."
  $decho $dscl -create /Groups/"$group"	&&
  $decho $dscl -create /Groups/"$group" RecordName "$group"	&&
  $decho $dscl -create /Groups/"$group" PrimaryGroupID "$group_id"	&&
  $decho $dscl -create /Groups/"$group" RealName "$comment"	&&
  $mk_home_dir && $decho sudo mkdir "$home_dir" || true
}
clear_properties	&&
reset_properties "$@"	&&
print_properties	&&
dothe_properties
