#!/bin/ksh
[ "${LOGNAME:-$USER}" = root ] ||
decho=echo
spritcomma(){
  for a in "$@"; do
    echo "$a" | sed -e "s/,/ /g"
  done
}
joincomma(){
  echo "$@" | sed -e "s/  */,/g"
}
getpwvalue(){
  #dscl="dscl $localnet_dscl_domain"
  dscl="dscl ."
  $dscl -read /Users/"$1" "$2" | sed -ne "1{;s/^$2:[	 ]*\\(.*\\)\$/\\1/p;q;}"
}
getgrnam(){
  dscl="dscl ."
  kv=$($dscl -read /Groups/"$1" PrimaryGroupID 2> /dev/null) || return 1
  echo "$kv" | sed -ne 's/.* \([0-9][0-9]*\)/\1/p'
}
getgrgid(){
  dscl="dscl ."
  kv=$($dscl -search /Groups PrimaryGroupID "$1" 2> /dev/null) &&
  [ "$kv" != "" ] || return 1
  echo "$kv" | sed -ne '1{;s/^\([^	 ]*\)[	 ]*PrimaryGroupID.*/\1/p;q;}'
}
print_usage(){
  me=$(basename "$0")
  cat <<EOF
$me - delete a user account and related files and records
usage:
	$me [-h|--help] [--dry-run] [options] login
	sudo $me [--all-groups] [-r] login

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
clear_properties(){
  home_dir=
  groups='admin'
  access_list='
com.apple.access_ftp
com.apple.access_backup
com.apple.access_vpn
com.apple.access_calendar
com.apple.access_afp
com.apple.access_smb
com.apple.access_devicemanagement
com.apple.access_mail
com.apple.access_chat
com.apple.access_addressbook
admin
'
  access_list='
admin
'
  rm_home_dir=false
  login=
}
reset_properties(){
  [ $# -gt 0 ] || { print_usage; exit 1; }
  eval login="\${$#}"
  #dscl="dscl $localnet_dscl_domain"
  dscl="dscl ."
  $dscl -readall /Users | grep -q -e "^RecordName: $login\$" || return 1
  home_dir=$(getpwvalue "$login" NFSHomeDirectory)
  while [ $# -gt 0 ]; do
    case "$1" in
    -h|--help)	print_usage; exit 0;;
    --dry-run)	decho=echo;;
    --all-groups)
      groups=$(joincomma $($dscl -search /Groups GroupMembership "$login" | sed -ne 's/^\([^	 ]*\)[	 ]*GroupMembership.*/\1/p'))
      #access_list=$(dscl . -search /Groups GroupMembership "$login" | sed -ne 's/^\([^	 ]*\)[	 ]*GroupMembership.*/\1/p')
      access_list=
      ;;
    -r)	rm_home_dir=:;;
    esac
    shift
  done
  user_id=$(getpwvalue "$login" UniqueID)
}
print_properties(){
  cat <<EOF
home_dir:	$home_dir
groups:		$groups
rm_home_dir:	$rm_home_dir
login:		$login
user_id:	$user_id
EOF
  echo
}
dothe_properties(){
  #dscl="dscl $localnet_dscl_flags $localnet_dscl_domain"
  dscl="dscl ."
  $decho $dscl -delete /Users/"$login" &&
  for g in $(spritcomma "$groups"); do
    case "$g" in
    *[^0-9]*);;
    *)	g=$(getgrgid "$g") || continue;;
    esac
    $dscl -read /Groups/"$g" GroupMembership 2> /dev/null | grep -q "\b$login\b" || continue
    $decho $dscl -delete /Groups/"$g" GroupMembership "$login"		||
    echo error: $dscl -delete /Groups/"$g" GroupMembership "$login"
  done &&
  #
  dscl="dscl ."
  for g in $access_list; do
    case "$g" in
    *[^0-9]*);;
    *)	g=$(getgrgid "$g") || continue;;
    esac
    $dscl -read /Groups/"$g" GroupMembership 2> /dev/null | grep -q "\b$login\b" || continue
    $decho $dscl -delete /Groups/"$g" GroupMembership "$login"		||
    echo error: $dscl -delete /Groups/"$g" GroupMembership "$login"
  done
  $rm_home_dir || return 0
  [ -d "$home_dir" ] || return 0
  $decho mv "$home_dir" "$home_dir".deleted-$(date '+%Y%m%d%H%M%S')
}
clear_properties	&&
reset_properties "$@"	&&
print_properties	&&
dothe_properties
