#!/bin/ksh
print_usage(){
  cat <<EOF
usage:
	$(basename $0) [-h|--help] [--dry-run]

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
while [ $# -gt 0 ]; do
  case "$1" in
  -h|--help)	print_usage; exit 0;;
  --dry-run)	decho=echo;;
  esac
  shift
done

kept_file(){	# $0 /etc/sshd_config
  keep_file="$1"
  kept_file=
  if [ -f "$keep_file" ]; then
    kept_file="${keep_file}~"
    while [ -f "$kept_file" ]; do kept_file="${kept_file}~"; done
    echo "$kept_file"
    return 0
  else
    echo "$keep_file"
    return 1
  fi
}
modify_defaults__GlobalPreferences(){	# $0 "$HOME"/Library/Preferences/.GlobalPreferences
  defaults read "$1" | sed -e '
/^ *AppleLocale = */s/"[^"][^"]*"/"ja_JP"/
/^ *AppleLanguages = *(/,/^ *)/{
  /^ *AppleLanguages = *(/{
    n
    h
    s/[^ ,][^ ,]*/ja/
    p
    x
  }
  /^ *ja,$/d
}
'
}
{
  keep_file="$HOME"/Library/Preferences/.GlobalPreferences.plist
  base_path=$(dirname "$keep_file")/$(basename "$keep_file" .plist)
  diff -u <(defaults read "$base_path") <(modify_defaults__GlobalPreferences "$base_path") > /dev/null || {
    kept_file=$(kept_file "$keep_file") &&
    new_plist=$(modify_defaults__GlobalPreferences "$base_path") &&
    $decho cp -p "$keep_file" "$kept_file" &&
    $decho defaults write "$base_path" "$new_plist"
  }
}
