#!/bin/ksh
[ "${LOGNAME:-$USER}" = root ] ||
decho=echo
localnet_dscl_flags='-u diradmin -p'
localnet_dscl_domain='/LDAPv3/127.0.0.1'
spritcomma(){
  for a in "$@"; do
    echo "$a" | sed -e "s/,/ /g"
  done
}
getgrnam(){
  dscl="dscl $localnet_dscl_domain"
  kv=$($dscl -read /Groups/"$1" PrimaryGroupID 2> /dev/null) || {
    dscl="dscl ."
    kv=$($dscl -read /Groups/"$1" PrimaryGroupID 2> /dev/null) || return 1
  }
  echo "$kv" | sed -ne 's/.* \([0-9][0-9]*\)/\1/p'
}
getgrgid(){
  dscl="dscl $localnet_dscl_domain"
  kv=$($dscl -search /Groups PrimaryGroupID "$1" 2> /dev/null) &&
  [ "$kv" != "" ] || {
    dscl="dscl ."
    kv=$($dscl -search /Groups PrimaryGroupID "$1" 2> /dev/null) &&
    [ "$kv" != "" ] || return 1
  }
  echo "$kv" | sed -ne '1{;s/^\([^	 ]*\)[	 ]*PrimaryGroupID.*/\1/p;q;}'
}
last_uid(){
  { dscl . -readall /Users; dscl $localnet_dscl_domain -readall /Users; } |
  sed -ne 's/^UniqueID: \([0-9][0-9]*\)/\1/p' |
  sort -n | tail -n 1
}
print_usage(){
  me=$(basename "$0")
  cat <<EOF
$me - create a new user
usage:
	$me [-h|--help] [--dry-run] [--dscl '$localnet_dscl_flags'] [--domain $localnet_dscl_domain] [options] login
	sudo $me [-c full_name] [-d home_dir] [-g group] [-G group1[,group2]...] [-p password] [-s shell] [-u uid] [--admin] [-m] [--post command] login

copyright:
	Copyright (C) 2013 Taiji Yamada <taiji@aihara.co.jp>
	This program is distributed under the BSD 2-clause license.
	See http://opensource.org/licenses/BSD-2-Clause
EOF
}
clear_properties(){
  comment=
  home_dir=
  initial_group=20
  groups=
  access_list='
com.apple.access_ftp
com.apple.access_backup
com.apple.access_vpn
com.apple.access_calendar
com.apple.access_afp
com.apple.access_smb
com.apple.access_devicemanagement
com.apple.access_mail
com.apple.access_chat
com.apple.access_addressbook
'
  access_list0=
  passwd=
  default_shell=/bin/bash
  user_id=$(($(last_uid)+1))
  first_name=
  last_name=
  is_admin=false
  mk_home_dir=false
  post_command=
  login=
}
print_properties(){
  cat <<EOF
comment:	$comment
home_dir:	$home_dir
initial_group:	$initial_group
groups:		$groups
passwd:		$passwd
default_shell:	$default_shell
user_id:	$user_id
first_name:	$first_name
last_name:	$last_name
is_admin:	$is_admin
mk_home_dir:	$mk_home_dir
post_command:	$post_command
login:		$login
EOF
  echo
}
reset_properties(){
  [ $# -gt 0 ] || { print_usage; exit 1; }
  eval login="\${$#}"
  dscl="dscl $localnet_dscl_domain"
  #dscl="dscl ."
  $dscl -readall /Users | grep -q -e "^RecordName: $login\$" && return 1
  home_dir="/Users/$login"
  while [ $# -gt 0 ]; do
    case "$1" in
    -h|--help)	print_usage; exit 0;;
    --dry-run)	decho=echo;;
    --dscl)	[ $# -gt 1 ] && shift && localnet_dscl_flags="$1";;
    --domain)	[ $# -gt 1 ] && shift && localnet_dscl_domain="$1";;
    -c)	[ $# -gt 1 ] && shift && comment="$1";;
    -d)	[ $# -gt 1 ] && shift && home_dir="$1";;
    -g)	[ $# -gt 1 ] && shift && initial_group="$1";;
    -G)	[ $# -gt 1 ] && shift && groups="$1";;
    -p)	[ $# -gt 1 ] && shift && passwd="$1";;
    -s)	[ $# -gt 1 ] && shift && default_shell="$1";;
    -u)	[ $# -gt 1 ] && shift && user_id="$1";;
    --admin)	is_admin=:;;
    -m)	mk_home_dir=:;;
    --post)	[ $# -gt 1 ] && shift && post_command="$1";;
    esac
    shift
  done
  [ "$comment" != "" ] || comment="$login"
  [ "$comment" = "" ] || {
    case "$comment" in
    [a-zA-Z]*)
      first_name=$(echo "$comment" | sed -ne 's/^\([^ ]*\) .*$/\1/p')
      last_name=$(echo "$comment" | sed -ne 's/^.* \([^ ]*\)$/\1/p')
      ;;
    *)
      last_name=$(echo "$comment" | sed -ne 's/^\([^ ]*\) .*$/\1/p')
      first_name=$(echo "$comment" | sed -ne 's/^.* \([^ ]*\)$/\1/p')
      ;;
    esac
  }
  case "$initial_group" in
  *[^0-9]*)	initial_group=$(getgrnam "$initial_group") || exit 1;;
  esac
  ! $is_admin || {
    groups="$groups,admin"
    access_list="$access_list admin"
  }
}
dothe_properties(){
  dscl="dscl $localnet_dscl_flags $localnet_dscl_domain"
  #dscl="dscl ."
  $decho $dscl -create /Users/"$login"  &&
  $decho $dscl -create /Users/"$login" RecordName "$login"		&&
  [ "$passwd" = "" ] ||
  $decho $dscl -passwd /Users/"$login" "$passwd"			&&
  $decho $dscl -create /Users/"$login" UniqueID "$user_id"		&&
  $decho $dscl -create /Users/"$login" PrimaryGroupID "$initial_group"	&&
  $decho $dscl -create /Users/"$login" NFSHomeDirectory "$home_dir" 	&&
  $decho $dscl -create /Users/"$login" RealName "$comment"		&&
  [ "$last_name" = "" ] ||
  $decho $dscl -create /Users/"$login" LastName "$last_name"		&&
  [ "$first_name" = "" ] ||
  $decho $dscl -create /Users/"$login" FirstName "$first_name"		&&
  $decho $dscl -create /Users/"$login" UserShell "$default_shell"	&&
  for g in $(spritcomma "$groups"); do
    case "$g" in
    *[^0-9]*);;
    *)	g=$(getgrgid "$g") || continue;;
    esac
    $dscl -read /Groups/"$g" GroupMembership 2> /dev/null | grep -q "\b$login\b" && continue
    $decho $dscl -append /Groups/"$g" GroupMembership "$login"		||
    echo error: $dscl -append /Groups/"$g" GroupMembership "$login"
  done &&
  #
  dscl="dscl ."
  for g in $access_list; do
    case "$g" in
    *[^0-9]*);;
    *)	g=$(getgrgid "$g") || continue;;
    esac
    $dscl -read /Groups/"$g" GroupMembership 2> /dev/null | grep -q "\b$login\b" && continue
    $decho $dscl -append /Groups/"$g" GroupMembership "$login"		||
    echo error: $dscl -append /Groups/"$g" GroupMembership "$login"
  done
  ! $mk_home_dir || {
    $decho createhomedir -b -u "$login" && {
      [ "$post_command" = "" ] ||
      $decho su - "$login" -c "$post_command"
    }
  } &&
  return 0 ||
  return 1
}
clear_properties	&&
reset_properties "$@"	&&
print_properties	&&
dothe_properties
